<?php
require_once dirname(__DIR__) . '/config/db.php';

try {
    // Check if permission already exists
    $stmt = $pdo->prepare("SELECT id FROM permissions WHERE name = ?");
    $stmt->execute(['view_dashboard']);
    if (!$stmt->fetch()) {
        // Add the permission
        $stmt = $pdo->prepare("INSERT INTO permissions (name, description) VALUES (?, ?)");
        $stmt->execute([
            'view_dashboard',
            'Can view dashboard and analytics'
        ]);
        echo "Successfully added view_dashboard permission\n";
    } else {
        echo "Permission view_dashboard already exists\n";
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
} 